/* =========================================================
   Vannini Digital Catalog — app.js (desktop contain, mobile cover)
   ========================================================= */

(function () {
  // ---------- Utilities ----------
  var $ = function (sel, root) { return (root || document).querySelector(sel); };
  function faDigits(s) { return String(s).replace(/[0-9]/g, d => '۰۱۲۳۴۵۶۷۸۹'.charAt(d)); }
  function debounce(fn, wait) { var t; return function(){clearTimeout(t); t=setTimeout(()=>fn.apply(this, arguments), wait);} }

  // ---------- Data ----------
  var PRODUCTS = [
    {
      id:'kromalgin',
      fa:'الژینات هوشمند کرومالژین',
      en:'Kromalgin Più — Chromatic Alginate',
      cat:'Alginate', best:true,
      image:'assets/img/products/kromalgin.jpg',
      summary:'آلژینات کروماتیک بدون گردوغبار و عاری از گلوتن با نشانگر تغییر رنگ مرحله‌ای. مناسب قالب‌های روتین، مدل‌های تشخیصی و ارتودنسی.',
      features:['Chromatic indicator','Dustless','Gluten-free','Mint scent','High elastic recovery'],
      tags:['Chromatic','Alginate','Dustless','ISO 21563'],
      viscosity:'—', set:'—', shade:'Pink',
      specs:{ iso:'ISO 21563', ratio:'—', mixing:'45 ثانیه', working:'1:35', mouth:'1:00', setTime:'2:35', elasticRecovery:'96.0 %', tear:'0.65 N/mm', strain:'10.0 %', initSet:'2:25', color:'صورتی', scent:'نعنا' },
      pack:['Carton 24×453g','Carton 300×18g']
    },
    {
      id:'prestige-putty',
      fa:'ماده قالبگیری افزایشی پوتی نرمال‌ست پرستیژ',
      en:'Prestige Putty — Regular Set',
      cat:'VPS', best:true,
      image:'assets/img/products/prestige-putty.jpg',
      summary:'سیلیکون افزایشی تیکسوتروپیک برای ایمپرشن اول در تمام تکنیک‌های دابل (از جمله همزمان). پایداری ابعادی بالا و سختی متعادل.',
      features:['Thixotropic','High dimensional stability','Balanced hardness'],
      tags:['Putty','ISO 4823','Type 0','Regular'],
      viscosity:'Putty', set:'Regular', shade:'Deep Pink',
      specs:{ iso:'ISO 4823 / Type 0', ratio:'1:1', mixing:'30 ثانیه', working:'2:00', mouth:'3:30', setTime:'5:30', strain:'0.8–3.0 %', recovery:'>98.5 %', linear:'<0.30 %', shore:'70±5', color:'صورتی پررنگ' },
      pack:['Cod.055001 — 300ml/450g Base + 300ml/450g Catalyst']
    },
    {
      id:'prestige-putty-soft',
      fa:'پوتی فست‌ست پرستیژ (نرم)',
      en:'Prestige Putty Soft — Fast Set',
      cat:'VPS', best:true,
      image:'assets/img/products/prestige-putty-soft.jpg',
      summary:'پوتی بسیار نرم با ستینگ سریع برای ایمپرشن اول در تکنیک دابل. خروج آسان از دهان و پایداری ابعادی بالا.',
      features:['Extra soft','Fast intra-oral set','Easy removal'],
      tags:['Putty','Soft','Fast set','Type 0'],
      viscosity:'Putty', set:'Fast', shade:'Peach',
      specs:{ iso:'ISO 4823 / Type 0', ratio:'1:1', mixing:'30 ثانیه', working:'1:30', mouth:'2:30', setTime:'4:00', strain:'0.8–3.0 %', recovery:'>98.5 %', linear:'<0.30 %', shore:'58±5', color:'هلویی' },
      pack:['Cod.055002 — 300ml/450g Base + 300ml/450g Catalyst']
    },
    {
      id:'prestige-hydrolight',
      fa:'واش هیدرولایت پرستیژ (ستینگ سریع)',
      en:'Prestige Hydrolight — Fast Set (Hyper-hydrophilic)',
      cat:'VPS', best:true,
      image:'assets/img/products/prestige-hydrolight.jpg',
      summary:'لایت بادی فوق آبدوست برای ایمپرشن دوم؛ جابجایی مایعات و ثبت دقیق‌ترین حاشیه‌ها.',
      features:['Hyper-hydrophilic','High flow','High dimensional stability'],
      tags:['Light body','Fast set','Type 3'],
      viscosity:'Light', set:'Fast', shade:'Purple',
      specs:{ iso:'ISO 4823 / Type 3', ratio:'1:1', mixing:'Auto mix', working:'1:30', mouth:'2:30', setTime:'4:00', strain:'3.0–5.0 %', recovery:'>99.5 %', linear:'<0.20 %', shore:'45', color:'بنفش' },
      pack:['Cod.055107 — 2×50ml + 12 tips','Cod.055250 — 2×50ml','Cod.055407 — 10×50ml']
    },
    {
      id:'prestige-light-fast',
      fa:'واش لایت فست پرستیژ',
      en:'Prestige Light — Fast Set',
      cat:'VPS', best:true,
      image:'assets/img/products/prestige-light-fast.jpg',
      summary:'لایت بادی تیکسوتروپیک فست‌ست برای ایمپرشن دوم با دقت بالا در بازتولید جزئیات.',
      features:['Hydro-compatible','High accuracy'],
      tags:['Light body','Fast set','Type 3'],
      viscosity:'Light', set:'Fast', shade:'Blue',
      specs:{ iso:'ISO 4823 / Type 3', ratio:'1:1', mixing:'Auto mix', working:'1:30', mouth:'2:30', setTime:'4:00', strain:'2.0–5.0 %', recovery:'>99.0 %', linear:'<0.30 %', shore:'50±5', color:'آبی' },
      pack:['Cod.055106 — 2×50ml + 12 tips','Cod.055206 — 2×50ml','Cod.055425 — 10×50ml']
    },
    {
      id:'prestige-a-plus-light',
      fa:'واش نرمال‌ست پرستیژ A Plus Light',
      en:'Prestige A Plus Light — Regular Set',
      cat:'VPS', best:false,
      image:'assets/img/products/prestige-a-plus-light.jpg',
      summary:'لایت بادی نرمال‌ست سازگار با آب برای ایمپرشن دوم (و روش همزمان). دقت و پایداری ابعادی بالا.',
      features:['Hydro-compatible','Dimensional stability'],
      tags:['Light body','Regular set','Type 3'],
      viscosity:'Light', set:'Regular', shade:'Peach',
      specs:{ iso:'ISO 4823 / Type 3', ratio:'1:1', mixing:'2:00', working:'3:30', mouth:'5:30', setTime:'—', strain:'3.0–5.0 %', recovery:'>99.5 %', linear:'<0.20 %', shore:'45', color:'هلویی' },
      pack:['Cod.055108 — 2×50ml + 6 tips','Cod.055208 — 2×50ml']
    },
    {
      id:'prestige-bite',
      fa:'ماده ثبت بایت پرستیژ (سازگار با CAD/CAM)',
      en:'Prestige Bite — CAD/CAM-ready VPS',
      cat:'Bite', best:true,
      image:'assets/img/products/prestige-bite.jpg',
      summary:'VPS مخصوص بایت رجیستریشن؛ قابل خوانش با سیستم‌های سنتی یا CAD/CAM (نوری/لیزری/لمسی) و بازتولید دقیق داده‌های سه‌بعدی.',
      features:['High scan readability','Fast set in mouth'],
      tags:['Bite','CAD/CAM'],
      viscosity:'Bite', set:'—', shade:'Light Green',
      specs:{ ratio:'1:1', mixing:'30 ثانیه', working:'60 ثانیه', mouth:'2:00', setTime:'—', recoveryUm:'−0.05 µm', shore:'95', color:'سبز روشن' },
      pack:['Cod.055015 — 2×50ml + 12 tips','Cod.055215 — 2×50ml','Cod.055415 — 10×50ml']
    }
  ];

  // ---------- DOM ----------
  var spreads = $('#spreads'), tocList = $('#tocList');
  var q = $('#q'), cat = $('#cat'), sort = $('#sort');
  var btnPrint = $('#btnPrint'), btnToc = $('#btnToc'), toc = $('#toc');

  // ---------- Views ----------
  function kv(label, val){
    if(!val || val==='—') return '';
    return '<div class="row"><span class="label">'+label+'</span><span class="value">'+faDigits(val)+'</span></div>';
  }

  function mediaView(p){
    if (p.image){
      return (
        '<picture>' +
          // '<source type="image/webp" srcset="'+p.image.replace(/\.jpg$/i,'.webp')+'">' +
          '<img class="media-img" src="'+p.image+'" alt="'+(p.en||p.fa)+'" ' +
          'loading="lazy" decoding="async" width="1200" height="900">' +
        '</picture>'
      );
    }
    var brandTitle = (p.en||'').split('—')[0].trim();
    return '<div class="product__media-fallback">'+brandTitle+'</div>';
  }

  function productView(p){
    var s = p.specs || {};
    var feats = (p.features||[]).map(x=>'<li>'+x+'</li>').join('');
    var pills = [
      'ویسکوزیته: <b>'+(p.viscosity||'—')+'</b>',
      s.iso ? s.iso : '',
      s.color ? 'رنگ: '+s.color : ''
    ].filter(Boolean).map(x=>'<span class="pill">'+x+'</span>').join('');

    return [
      '<article class="spread product" id="'+p.id+'">',
        '<div class="product__content">',
          '<div class="product__head">',
            (p.best ? '<span class="badge best">پرفروش‌ترین</span>' : ''),
            '<span class="badge">'+p.cat+'</span>',
            (p.set && p.set!=='—' ? '<span class="badge">'+p.set+' Set</span>' : ''),
          '</div>',
          '<h3>'+p.fa+'</h3>',
          '<small>'+p.en+'</small>',
          '<p>'+p.summary+'</p>',
          '<div class="meta">'+pills+'</div>',
          '<div class="product__body">',
            '<ul>'+feats+'</ul>',
            '<div class="specs">'+
              kv('نسبت اختلاط', s.ratio) +
              kv('زمان اختلاط', s.mixing) +
              kv('زمان کار (Working)', s.working) +
              kv('زمان باقی‌ماندن در دهان', s.mouth) +
              kv('زمان ستینگ', s.setTime) +
              kv('Strain in Compression', s.strain) +
              kv('Elastic Recovery', s.recovery || s.elasticRecovery) +
              kv('Linear Dimensional Change 24h', s.linear) +
              kv('Hardness Shore A', s.shore) +
              kv('Recovery (µm)', s.recoveryUm) +
              kv('رایحه', s.scent) +
            '</div>',
            (p.pack && p.pack.length ? '<details><summary>پکینگ / کد سفارش</summary><ul>'+p.pack.map(i=>'<li>'+i+'</li>').join('')+'</ul></details>' : ''),
          '</div>',
        '</div>',
        '<div class="product__media">'+ mediaView(p) +'</div>',
      '</article>'
    ].join('');
  }

  function render(list){
    spreads.innerHTML = list.map(productView).join('');
    tocList.innerHTML = list.map(x=>'<li><a href="#'+x.id+'">'+x.fa+'</a></li>').join('');
  }

  // ---------- Filter / Sort ----------
  function apply(){
    var term = (q && q.value ? q.value : '').toLowerCase();
    var c = (cat && cat.value) ? cat.value : '';
    var srt = (sort && sort.value) ? sort.value : 'default';
    var list = PRODUCTS.slice();

    if(term){
      list = list.filter(p => (p.fa+' '+p.en+' '+p.summary+' '+(p.tags||[]).join(' ')).toLowerCase().indexOf(term) !== -1);
    }
    if(c){ list = list.filter(p => p.cat === c); }

    if(srt==='name') list.sort((a,b)=>a.fa.localeCompare(b.fa,'fa'));
    else if(srt==='set') list.sort((a,b)=>(a.set||'').localeCompare(b.set||''));
    else if(srt==='viscosity') list.sort((a,b)=>(a.viscosity||'').localeCompare(b.viscosity||''));

    render(list);
  }

  // ---------- Events ----------
  if (q) q.addEventListener('input', debounce(apply, 120));
  if (cat) cat.addEventListener('input', apply);
  if (sort) sort.addEventListener('input', apply);
  if (btnPrint) btnPrint.addEventListener('click', () => window.print());
  if (btnToc && toc){
    btnToc.addEventListener('click', function(){
      var open = toc.style.display === 'block';
      toc.style.display = open ? 'none' : 'block';
      btnToc.setAttribute('aria-expanded', String(!open));
      document.documentElement.scrollLeft = 0; document.body.scrollLeft = 0;
    });
  }

  // ---------- Init ----------
  render(PRODUCTS);
})();
